
/*============================================================================
 Name        : curses_print.c
 Author      :
 Date  	     : 2015.9
 Copyright   : ZKSoftware Inc.
 Description : Linux C
 ============================================================================*/
#include "serial.h"
#include "libtype.h"
#include "command_fun.h"
#include "libuserCmd.h"
#include "main.h"

VOID PrintInfo(VOID)
{
	INT x = 2;
	INT y = 1;

	mvwprintw(win, y++, x, "[01]--->EnrollUserByScan");
	mvwprintw(win, y++, x, "[02]--->EnrollTemplateByImage");
	mvwprintw(win, y++, x, "[03]--->GetFingerImage");
	mvwprintw(win, y++, x, "[04]--->IdentifyByImage");
	mvwprintw(win, y++, x, "[05]--->Verify");
	mvwprintw(win, y++, x, "[06]--->DeleteAllLogs");
	mvwprintw(win, y++, x, "[07]--->ClearDB");
	mvwprintw(win, y++, x, "[08]--->ReadAllLogs");
	mvwprintw(win, y++, x, "[09]--->SetTime");
	mvwprintw(win, y++, x, "[10]--->GetTime");
	mvwprintw(win, y++, x, "[11]--->GetStatus");
	mvwprintw(win, y++, x, "[12]--->GetParameter");
	mvwprintw(win, y++, x, "[13]--->SetParameter");
	mvwprintw(win, y++, x, "[14]--->SaveParameter");
	mvwprintw(win, y++, x, "[15]--->DeleteAllUsers");
	mvwprintw(win, y++, x, "[16]--->DeleteUser");
	mvwprintw(win, y++, x, "[17]--->ReadAllUsers");

	x = 50;
	y = 1;
	mvwprintw(win, y++, x, "[18]--->GetUser");
	mvwprintw(win, y++, x, "[19]--->ModifyUser");
	mvwprintw(win, y++, x, "[20]--->SetTemplates");
	mvwprintw(win, y++, x, "[21]--->DeleteTemplates");
	mvwprintw(win, y++, x, "[22]--->DeleteAllTemplates");
	mvwprintw(win, y++, x, "[23]--->ReadTemplates");
	mvwprintw(win, y++, x, "[24]--->ReadAllTemplates");
	mvwprintw(win, y++, x, "[25]--->ScanTemplates");
	mvwprintw(win, y++, x, "[26]--->EnableDevice");
	mvwprintw(win, y++, x, "[27]--->DisableDevice");
	mvwprintw(win, y++, x, "[28]--->Reset");
	mvwprintw(win, y++, x, "[29]--->Upgrade");

	mvwprintw(win, y++, x, "[66]--->Disconnect");
	mvwprintw(win, y++, x, "[77]--->Version");
	mvwprintw(win, y++, x, "[88]--->ViewData");
	mvwprintw(win, y++, x, "[99]--->AutoDubeg");
	mvwprintw(win, y++, x, "[00]--->Exit!");
	refresh();
	wrefresh(win);
	wrefresh(win1);//Tip info
	return;
}

INT input_info(INT *userID)
{

	while(1)
	{
		mvwprintw(win, 18, 2, "Please input userID:");
		wclrtoeol(win);
		if(mvwscanw(win, 18, 22, "%d", userID) != 1)
		{
			mvwprintw(win1, 1, 1, "Input parameter number err...");
			DebugWin(win1, 2);
			return FAILURE;
		}
		fflush(stdin);
		if(((*userID) >= 1) && ((*userID) <= USERID_MAX))
		{
			break;
		}
		else
		{
			mvwprintw(win1, 1, 1, "Input userID err...");
			DebugWin(win1, 2);
		}
	}
	return SUCCESS;
}

INT new_user(INT *userID, CHAR *name, CHAR *password, U8 *Card)
{
	if(input_info(userID) == FAILURE)
	{
		return FAILURE;
	}
	mvwprintw(win, 18, 2, "Please input name:");
	wclrtoeol(win);
	mvwscanw(win, 18, 20, "%s", name);
	name[7] = '\0';
	fflush(stdin);
	mvwprintw(win, 18, 2, "Please input password:");
	wclrtoeol(win);
	mvwscanw(win, 18, 24, "%s", password);
	password[4] = '\0';
	fflush(stdin);
	mvwprintw(win, 18, 2, "Please input Card:");
	wclrtoeol(win);
	mvwscanw(win, 18, 20, "%s", Card);
	Card[4] = '\0';
	fflush(stdin);
	return SUCCESS;
}

INT version(VOID)
{
	mvwprintw(win2, 6, 20, "[DEMOVersion] :Slk20 Demo_%s", DEMOVERSION);
	mvwprintw(win2, 7, 20, "[SDK Version] :Slk20 SDK_%s", SDKVERSION);
	mvwprintw(win2, 8, 20, "[ Copyright ] :ZKTeco");
	touchwin(win2);
	wrefresh(win2);
	wclear(win2);
	return SUCCESS;
}
